# -*- coding: iso-8859-1 -*-

#####################################################################
# Daniel Calderon S.
# CC3501
#####################################################################

# 04_Nave.py
# ---------------
# Dibuja una nave
# la nave se mueve horizontalmente siguiendo al mouse
# ---------------

# Implementacin testeada con:
## Python 2.6
## PyOpenGL 3.0.1
## PyGame 1.9.1

#####################################################################

# importar librera grfica
from OpenGL.GL import *
from OpenGL.GLU import *

# importar librera para manejar eventos
import pygame
from pygame.locals import *

#####################################################################
# Funciones de inicializacin
#####################################################################

def init_pygame((w,h), title=""):
    pygame.init()
    pygame.display.set_mode((w,h), OPENGL|DOUBLEBUF)
    pygame.display.set_caption(title)
	
def init():
    glClearColor(0.0, 0.0, 0.0, 0.0)
    glClearDepth(1.0)
    glDisable(GL_DEPTH_TEST)
    glShadeModel(GL_SMOOTH)
    glHint(GL_PERSPECTIVE_CORRECTION_HINT, GL_NICEST)
    glEnable (GL_BLEND)
    glBlendFunc (GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA)
    glHint (GL_LINE_SMOOTH_HINT, GL_NICEST)

def reshape((width, height)):
    if height == 0:
        height = 1
    glMatrixMode(GL_PROJECTION)
    glLoadIdentity()
    gluOrtho2D(0.0, width, 0.0, height)
    glMatrixMode(GL_MODELVIEW)
    glLoadIdentity()
	
def init_opengl((w,h)):
    init()
    reshape((w,h))

#####################################################################
# Funciones de dibujo
#####################################################################

def dibujarNave(px,py,rgb):
    glPushMatrix()
        
    glTranslatef(px,py,0.0)
    glColor4fv(rgb)

    glBegin(GL_POLYGON)

    glVertex2f(0,100)
    glVertex2f(30,0)
    glVertex2f(-30,0)
    			
    glEnd()
    glPopMatrix()
	
#####################################################################

w=800 # ancho
h=600 # alto

# inicializando ...
init_pygame((w,h),"Titulo")
init_opengl((w,h))

# definiendo la nave
px = 0
py = h/4
rgb = [1.0,1.0,1.0,1.0]

# medida de tiempo inicial
t0 = pygame.time.get_ticks()

run = True
while run:
    # 0: CONTROL DEL TIEMPO
	
    # tiempo actual
    t1 = pygame.time.get_ticks()
	
    # diferencial de tiempo asociado a la iteracin
    dt = (t1 - t0)
	
    # actualizar tiempo inicial para siguiente iteracin
    t0 = t1
	
    # 1: MANEJAMOS EVENTOS DE ENTRADA (TECLADO, MOUSE, ETC.)
    for event in pygame.event.get():
        # coordenadas del mouse
        mouse_pos=pygame.mouse.get_pos()
        px = mouse_pos[0]
		
        if event.type == QUIT:
            run = False
        if event.type == KEYDOWN:
            if event.key == K_ESCAPE:
                run = False
				
    # 2: EJECUTAMOS LOGICA DE LA APLICACION
	
    # 3: DIBUJAMOS LOS ELEMENTOS
    glClear(GL_COLOR_BUFFER_BIT) # limpia la pantalla
    dibujarNave(px,py,rgb)
	
    # vuelca el dibujo a la pantalla
    pygame.display.flip()

#####################################################################